/*
 * Decompiled with CFR 0.152.
 */
package Krasnodar.rockstarnew.utility.math;

import Krasnodar.rockstarnew.Rockstar;
import Krasnodar.rockstarnew.systems.modules.modules.combat.ElytraTarget;
import Krasnodar.rockstarnew.utility.game.prediction.ElytraPredictionSystem;
import Krasnodar.rockstarnew.utility.interfaces.IMinecraft;
import Krasnodar.rockstarnew.utility.math.calculator.ExpressionBuilder;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2533;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_337;
import net.minecraft.class_345;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public final class MathUtility
implements IMinecraft {
    private static final int TABLE_SIZE = 65536;
    private static final double TWO_PI = Math.PI * 2;
    private static final double[] TRIG_TABLE = new double[65536];

    public static double sin(double radians) {
        int index = (int)(radians * 10430.378350470453) & 0xFFFF;
        return TRIG_TABLE[index];
    }

    public static double cos(double radians) {
        int index = (int)(radians * 10430.378350470453 + 16384.0) & 0xFFFF;
        return TRIG_TABLE[index];
    }

    public static float random(double min, double max) {
        return (float)(min + (max - min) * Math.random());
    }

    public static double cubicBezier(double t, double p0, double p1, double p2, double p3) {
        return Math.pow(1.0 - t, 3.0) * p0 + 3.0 * t * Math.pow(1.0 - t, 2.0) * p1 + 3.0 * Math.pow(t, 2.0) * (1.0 - t) * p2 + Math.pow(t, 3.0) * p3;
    }

    public static boolean canSeen(class_243 targetVec) {
        return MathUtility.mc.field_1687.method_17742(new class_3959(MathUtility.mc.field_1724.method_33571(), targetVec, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)MathUtility.mc.field_1724)).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean canShoot(class_243 targetVec) {
        class_243 start = MathUtility.mc.field_1724.method_33571();
        class_243 direction = targetVec.method_1020(start);
        double distance = direction.method_1033();
        direction = direction.method_1029();
        HashSet<class_2338> checkedBlocks = new HashSet<class_2338>();
        int solidBlocks = 0;
        double step = 0.25;
        for (double d = 0.0; d <= distance; d += step) {
            class_265 collisionShape;
            class_243 currentPos = start.method_1019(direction.method_1021(d));
            class_2338 blockPos = class_2338.method_49638((class_2374)currentPos);
            if (checkedBlocks.contains(blockPos)) continue;
            checkedBlocks.add(blockPos);
            class_2680 blockState = MathUtility.mc.field_1687.method_8320(blockPos);
            if (blockState.method_26215()) continue;
            class_2248 block = blockState.method_26204();
            if (blockState.method_27852(class_2246.field_10033) || blockState.method_27852(class_2246.field_10285) || blockState.method_26204() instanceof class_2533 || (collisionShape = blockState.method_26220((class_1922)MathUtility.mc.field_1687, blockPos)).method_1110()) continue;
            ++solidBlocks;
        }
        AtomicBoolean snipe = new AtomicBoolean(false);
        class_337 boss = MathUtility.mc.field_1705.method_1740();
        if (boss != null) {
            Class<class_337> bossbarklass = class_337.class;
            try {
                Field field = bossbarklass.getField("bossBars");
                Map bossBars = (Map)field.get(boss);
                for (UUID uuid : bossBars.keySet()) {
                    class_345 clientBossBar = (class_345)bossBars.get(uuid);
                    List siblings = clientBossBar.method_5414().method_10855();
                    siblings.stream().allMatch(text -> {
                        if (text.getString().contains("\ub8f3\ua223\ua203\ub8f2\ua223\ua205")) {
                            snipe.set(true);
                        }
                        return true;
                    });
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return solidBlocks <= (snipe.get() ? 3 : (MathUtility.mc.field_1724.method_31548().field_7545 == 0 ? 2 : 1));
    }

    public static int levenshtein(String a, String b) {
        int n = a.length();
        int m = b.length();
        int[] dp = new int[m + 1];
        int j = 0;
        while (j <= m) {
            dp[j] = j++;
        }
        for (int i = 1; i <= n; ++i) {
            int prev = dp[0];
            dp[0] = i;
            for (int jx = 1; jx <= m; ++jx) {
                int tmp = dp[jx];
                int cost = a.charAt(i - 1) == b.charAt(jx - 1) ? 0 : 1;
                dp[jx] = Math.min(Math.min(dp[jx] + 1, dp[jx - 1] + 1), prev + cost);
                prev = tmp;
            }
        }
        return dp[m];
    }

    public static float interpolate(double oldValue, double newValue, double interpolationValue) {
        return (float)(oldValue + (newValue - oldValue) * interpolationValue);
    }

    public static class_239 rayTrace(double rayTraceDistance, float yaw, float pitch, class_1297 entity) {
        class_243 startVec = MathUtility.mc.field_1724.method_5836(1.0f);
        class_243 directionVec = MathUtility.getVectorForRotation(pitch, yaw);
        class_243 endVec = startVec.method_1031(directionVec.field_1352 * rayTraceDistance, directionVec.field_1351 * rayTraceDistance, directionVec.field_1350 * rayTraceDistance);
        return MathUtility.mc.field_1687.method_17742(new class_3959(startVec, endVec, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, entity));
    }

    public static boolean tracedTo(class_1297 shooter, class_243 startVec, class_243 endVec, class_238 boundingBox, Predicate<class_1297> filter, double distance, class_1297 target) {
        class_1937 world = shooter.method_37908();
        double d0 = distance;
        for (class_1297 entity1 : world.method_8333(shooter, boundingBox, filter)) {
            class_238 box = entity1.method_5829().method_1014((double)entity1.method_5871());
            Optional optional = box.method_992(startVec, endVec);
            if (box.method_1006(startVec)) {
                if (!(d0 >= 0.0)) continue;
                if (entity1 == target) {
                    return true;
                }
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent()) continue;
            class_243 vec3d1 = (class_243)optional.get();
            double d1 = startVec.method_1025(vec3d1);
            if (entity1.method_5668() == shooter.method_5668()) {
                if (d0 != 0.0 || entity1 != target) continue;
                return true;
            }
            if (entity1 == target) {
                return true;
            }
            d0 = d1;
        }
        return false;
    }

    public static boolean canTraceWithBlock(double rayTraceDistance, float yaw, float pitch, class_1297 entity, class_1297 target, boolean checkBlocks) {
        if (target != null && entity != null && MathUtility.mc.field_1687 != null) {
            double targetDistSq;
            double blockDistSq;
            class_3965 blockHit;
            class_243 endPos;
            float partialTicks = mc.method_61966().method_60637(false);
            class_243 startPos = entity.method_5836(partialTicks);
            if (Rockstar.getInstance().getModuleManager().getModule(ElytraTarget.class).isEnabled() && target instanceof class_1657) {
                class_1657 player = (class_1657)target;
                v0 = player.method_5829().method_997(ElytraPredictionSystem.predictPlayerPosition(player)).method_989(-player.method_23317(), -player.method_23318(), -player.method_23321()).method_1005();
            } else {
                v0 = endPos = target.method_5829().method_1005();
            }
            if (checkBlocks && (blockHit = MathUtility.mc.field_1687.method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity))) != null && blockHit.method_17783() == class_239.class_240.field_1332 && (blockDistSq = blockHit.method_17784().method_1025(startPos)) < (targetDistSq = endPos.method_1025(startPos))) {
                return false;
            }
            class_243 direction = MathUtility.getVectorForRotation(pitch, yaw);
            class_243 rayEnd = startPos.method_1019(direction.method_1021(rayTraceDistance));
            class_238 searchBox = entity.method_5829().method_18804(direction.method_1021(rayTraceDistance)).method_1014(1.0);
            return MathUtility.tracedTo(entity, startPos, rayEnd, searchBox, e -> !e.method_7325() && e.method_5863(), rayTraceDistance * rayTraceDistance, target);
        }
        return false;
    }

    public static class_243 getVectorForRotation(float pitch, float yaw) {
        float yawRadians = -yaw * ((float)Math.PI / 180) - (float)Math.PI;
        float pitchRadians = -pitch * ((float)Math.PI / 180);
        float cosYaw = class_3532.method_15362((float)yawRadians);
        float sinYaw = class_3532.method_15374((float)yawRadians);
        float cosPitch = -class_3532.method_15362((float)pitchRadians);
        float sinPitch = class_3532.method_15374((float)pitchRadians);
        return new class_243((double)(sinYaw * cosPitch), (double)sinPitch, (double)(cosYaw * cosPitch));
    }

    public static float angleDifference(float angle1, float angle2) {
        float diff = (angle1 - angle2) % 360.0f;
        if (diff < -180.0f) {
            diff += 360.0f;
        } else if (diff > 180.0f) {
            diff -= 360.0f;
        }
        return diff;
    }

    public static String calculate(String expression) {
        if ((expression = expression.replaceAll("\\s+", "")).isEmpty()) {
            return "";
        }
        try {
            double result = new ExpressionBuilder(expression).build().evaluate();
            return String.valueOf(result);
        }
        catch (IllegalArgumentException var3) {
            var3.printStackTrace();
            return expression;
        }
    }

    @Generated
    private MathUtility() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        for (int i = 0; i < 65536; ++i) {
            MathUtility.TRIG_TABLE[i] = Math.sin((double)i * (Math.PI * 2) / 65536.0);
        }
    }
}

